'''
Created on 2011. 4. 26.

@author: rex8312
'''
import sys, wx, webbrowser
import win32con
#import SendKeys
#import win32com.client, win32gui, win32api
import subprocess
import time

CONFIG = {}
ID_ICON_TIMER = wx.NewId()  
OPEN_BROWSER=wx.NewId()  
OPEN_PREFS=wx.NewId()
HOTKEY_ID = wx.NewId()
_WORD = 'qwertyuiopasdfghjklzxcvbnm'

class MailTaskBarIcon(wx.TaskBarIcon):  
    def __init__(self, parent):  
        wx.TaskBarIcon.__init__(self)  
        self.parentApp = parent  
        self.noMailIcon = wx.Icon("MyDic.png",wx.BITMAP_TYPE_PNG)  
        #self.youHaveMailIcon = wx.Icon("mail-message-new.png",wx.BITMAP_TYPE_PNG)  
        self.CreateMenu()
        self.SetIcon(self.noMailIcon)

    def CreateMenu(self):  
        self.Bind(wx.EVT_TASKBAR_RIGHT_UP, self.ShowMenu)  
        self.Bind(wx.EVT_MENU, self.parentApp.OpenBrowser, id=OPEN_BROWSER)
        #self.Bind(wx.EVT_MENU, self.parentApp.OpenPrefs, id=OPEN_PREFS)
        self.menu=wx.Menu()  
        self.menu.Append(OPEN_BROWSER, "Info")  
        #self.menu.Append(OPEN_PREFS, "Open Preferences")  
        self.menu.AppendSeparator()
        self.menu.Append(wx.ID_EXIT, "Close")

    def ShowMenu(self,event):  
        self.PopupMenu(self.menu)

class MailFrame(wx.Frame):  

    def __init__(self, parent, id, title):  
        wx.Frame.__init__(self, parent, -1, title, size = (1, 1),  
            style=wx.FRAME_NO_TASKBAR|wx.NO_FULL_REPAINT_ON_RESIZE)  
        self.myDicViewWindow = subprocess.Popen(['MyDicView.exe'], shell=True).kill()
        self.tbicon = MailTaskBarIcon(self)  
        self.tbicon.Bind(wx.EVT_MENU, self.exitApp, id=wx.ID_EXIT)
        
        self.regHotKey()
        self.Bind(wx.EVT_HOTKEY, self.findWord, id=HOTKEY_ID)
         
        self.Show(True)  

    def exitApp(self,event):  
        self.tbicon.RemoveIcon()  
        self.tbicon.Destroy()  
        sys.exit()

    def OpenBrowser(self,event):  
        webbrowser.open('http://cilab.sejong.ac.kr/home/doku.php?id=public:util:mydic')  

    #def OpenPrefs(self,event):  
    #    pass
    
    def regHotKey(self):
        hotkey = CONFIG['HOTKEY']
        #self.RegisterHotKey(HOTKEY_ID, win32con.MOD_ALT, win32con.VK_F1)
        self.RegisterHotKey(HOTKEY_ID, hotkey[0], hotkey[1])
    
    def findWord(self, event):
        global _WORD
        #subprocess.call(['python', 'MyDicGetText.py'])     
        for i in range(10):    
            subprocess.call(['python', 'MyDicGetText.py'])
            time.sleep(0.5)
            if wx.TheClipboard.Open():
                do = wx.TextDataObject()
                if wx.TheClipboard.GetData(do):
                    word = do.GetText()
                #print word
                #webbrowser.open('http://www.google.co.kr/dictionary?langpair=en|ko&q=%s&hl=ko&aq=f'%(word.strip()))            
                    if word != _WORD:
                        uri = CONFIG['URI_TEMPLATE']%(word.strip())
                        print uri
                        try:
                            self.myDicViewWindow.kill()
                        except:
                            pass
                        self.myDicViewWindow = subprocess.Popen(['python.exe', 'MyDicView.py', uri])
                        #self.myDicViewWindow = subprocess.Popen(['MyDicView.exe', uri])
                        _WORD = word
                        print 'WORD:', word
                        break
                    else:
                        print 'EXCEPTION count:', i
            
                wx.TheClipboard.Close()
        
def main(argv=None):
    global CONFIG
    with open('MyDic.ini', 'rt') as f:
        cs = f.readlines()
        for c in cs:
            key = c.split('=', 1)[0].strip()
            value = eval(c.split('=', 1)[1].strip())
            CONFIG[key] = value
            
    app = wx.App(False)  
    frame = MailFrame(None, -1, ' ')  
    frame.Center(wx.BOTH)  
    frame.Show(False) 
    app.MainLoop()  

if __name__ == '__main__':  
    main()
