'''
Created on 2011. 4. 26.

@author: Hyunsoo Park, CILab, Computer Dept., Sejong Univ.
'''
import sys, wx, webbrowser
import win32con
import subprocess
import time
import pytranslate
import os.path

CONFIG = {}
ID_ICON_TIMER = wx.NewId()  
OPEN_BROWSER=wx.NewId()  
OPEN_PREFS=wx.NewId()
DIC_HOTKEY_ID = wx.NewId()
TRANS_HOTKEY_ID = wx.NewId()

class MyDicTaskBarIcon(wx.TaskBarIcon):  
    def __init__(self, parent):  
        wx.TaskBarIcon.__init__(self)  
        self.parentApp = parent  
        self.MyDicIcon = wx.Icon("MyDic.png",wx.BITMAP_TYPE_PNG)  
        self.CreateMenu()
        self.SetIcon(self.MyDicIcon)

    def CreateMenu(self):  
        self.Bind(wx.EVT_TASKBAR_RIGHT_UP, self.ShowMenu)  
        self.Bind(wx.EVT_MENU, self.parentApp.OpenBrowser, id=OPEN_BROWSER)
        #self.Bind(wx.EVT_MENU, self.parentApp.OpenPrefs, id=OPEN_PREFS)
        self.menu=wx.Menu()  
        self.menu.Append(OPEN_BROWSER, "Info")  
        #self.menu.Append(OPEN_PREFS, "Open Preferences")  
        self.menu.AppendSeparator()
        self.menu.Append(wx.ID_EXIT, "Close")

    def ShowMenu(self,event):  
        self.PopupMenu(self.menu)

class MyDicFrame(wx.Frame):  

    def __init__(self, parent, id, title):  
        wx.Frame.__init__(self, parent, -1, title, size = (1, 1),  
            style=wx.FRAME_NO_TASKBAR|wx.NO_FULL_REPAINT_ON_RESIZE)
        self.myDicViewWindow = subprocess.Popen(CONFIG['MyDicGetText'], shell=True).kill()
        self.tbicon = MyDicTaskBarIcon(self)  
        self.tbicon.Bind(wx.EVT_MENU, self.exitApp, id=wx.ID_EXIT)
        self.regHotKey()
        self.Bind(wx.EVT_HOTKEY, self.findWord, id=DIC_HOTKEY_ID)
        self.Bind(wx.EVT_HOTKEY, self.translate, id=TRANS_HOTKEY_ID)         
        self.Show(True)  

    def exitApp(self,event):  
        self.tbicon.RemoveIcon()  
        self.tbicon.Destroy()  
        sys.exit()

    def OpenBrowser(self,event):  
        webbrowser.open('http://cilab.sejong.ac.kr/home/doku.php?id=public:util:mydic')  
    
    def regHotKey(self):
        dic_hotkey = CONFIG['DIC_HOTKEY']
        trans_hotkey = CONFIG['TRANS_HOTKEY']
        self.RegisterHotKey(DIC_HOTKEY_ID, dic_hotkey[0], dic_hotkey[1])
        self.RegisterHotKey(TRANS_HOTKEY_ID, trans_hotkey[0], trans_hotkey[1])
    
    def findWord(self, event):
        subprocess.call(CONFIG['MyDicGetText'])
        time.sleep(0.3)
        if wx.TheClipboard.Open():
            do = wx.TextDataObject()
            if wx.TheClipboard.GetData(do):
                word = do.GetText()
                uri = CONFIG['URI_TEMPLATE']%(word.strip())
                print uri
                try:
                    self.myDicViewWindow.kill()
                except:
                    pass
                self.myDicViewWindow = subprocess.Popen(CONFIG['MyDicView']+[uri])
                print 'WORD:', word
            
                wx.TheClipboard.Close()

    def translate(self, event):
        subprocess.call(CONFIG['MyDicGetText'])
        time.sleep(0.3)
        if wx.TheClipboard.Open():
            do = wx.TextDataObject()
            if wx.TheClipboard.GetData(do):
                word = do.GetText()
                #trans = 'Not yet supported. Use python script'
                trans = pytranslate.translate(word, tl='korean').decode('utf-8')
                print 'WORD:', word
                print 'TRANS:', trans
                mouse_x = wx.GetDisplaySize()[0]/2 + event.GetX() - 30
                mouse_y = wx.GetDisplaySize()[1]/2 + event.GetY()
                        #wx.MessageBox(trans, 'Translate')
                td = TransDialog(self, -1, 'Translate', mpos=(mouse_x, mouse_y), text=trans)
                td.Show()
                wx.TheClipboard.Close()


class TransDialog(wx.Frame):
    def __init__(self, parent, id, title, mpos, text):
#        wx.Frame.__init__(self, parent, id, title, size=(200, 100), pos=mpos, style=wx.CLOSE_BOX | wx.STAY_ON_TOP)
        wx.Frame.__init__(self, parent, id, title, size=(400, 100), pos=mpos, style=wx.SYSTEM_MENU | wx.CAPTION | wx.CLOSE_BOX | wx.STAY_ON_TOP | wx.RESIZE_BORDER)
        
        vbox = wx.BoxSizer(wx.VERTICAL)
        panel = wx.Panel(self, -1, size=(400, 100))
        panel.SetBackgroundColour('#ffffff')
        trans = wx.StaticText(panel, -1, text, style=wx.ALIGN_LEFT)
        vbox.Add(trans,  1, wx.EXPAND |  wx.TOP | wx.BOTTOM | wx.LEFT | wx.RIGHT, border=10)
        panel.SetSizer(vbox)

def main(argv=None):
    global CONFIG
    with open('MyDic.ini', 'rt') as f:
        cs = f.readlines()
        for c in cs:
            key = c.split('=', 1)[0].strip()
            value = eval(c.split('=', 1)[1].strip())
            CONFIG[key] = value

    if os.path.isfile('MyDicGetText.py'):
        CONFIG['MyDicGetText'] = ['python', 'MyDicGetText.py']
    else:
        CONFIG['MyDicGetText'] = ['MyDicGetText.exe']

    if os.path.isfile('MyDicView.py'):
        CONFIG['MyDicView'] = ['python', 'MyDicView.py']
    else:
        CONFIG['MyDicView'] = ['MyDicView.exe']
            
    app = wx.App(False)  
    frame = MyDicFrame(None, -1, ' ')  
    frame.Center(wx.BOTH)  
    frame.Show(False) 
    app.MainLoop()  

if __name__ == '__main__':  
    main()
