'''
Created on 2011. 4. 26.

@author: rex8312
'''
import sys, wx, webbrowser
import win32con
import subprocess
import time

CONFIG = {}
ID_ICON_TIMER = wx.NewId()  
OPEN_BROWSER=wx.NewId()  
HOTKEY_ID = wx.NewId()
_WORD = 'qwertyuiopasdfghjklzxcvbnm'

class MyDicTaskBarIcon(wx.TaskBarIcon):  
    def __init__(self, parent):  
        wx.TaskBarIcon.__init__(self)  
        self.parentApp = parent  
        self.noMailIcon = wx.Icon("MyDic.png",wx.BITMAP_TYPE_PNG)  
        self.CreateMenu()
        self.SetIcon(self.noMailIcon)

    def CreateMenu(self):  
        self.Bind(wx.EVT_TASKBAR_RIGHT_UP, self.ShowMenu)  
        self.Bind(wx.EVT_MENU, self.parentApp.OpenBrowser, id=OPEN_BROWSER)
        self.menu=wx.Menu()  
        self.menu.Append(OPEN_BROWSER, "Info")  
        self.menu.AppendSeparator()
        self.menu.Append(wx.ID_EXIT, "Close")

    def ShowMenu(self,event):  
        self.PopupMenu(self.menu)

class MyDicFrame(wx.Frame):  

    def __init__(self, parent, id, title):  
        wx.Frame.__init__(self, parent, -1, title, size = (1, 1),  
            style=wx.FRAME_NO_TASKBAR|wx.NO_FULL_REPAINT_ON_RESIZE)  

        self.tbicon = MyDicTaskBarIcon(self)  
        self.tbicon.Bind(wx.EVT_MENU, self.exitApp, id=wx.ID_EXIT)
        
        self.regHotKey()
        self.Bind(wx.EVT_HOTKEY, self.findWord, id=HOTKEY_ID)
         
        self.Show(True)  

    def exitApp(self,event):  
        self.tbicon.RemoveIcon()  
        self.tbicon.Destroy()  
        sys.exit()

    def OpenBrowser(self,event):  
        webbrowser.open('http://cilab.sejong.ac.kr/home/doku.php?id=public:util:mydic')  
    
    def regHotKey(self):
        hotkey = CONFIG['HOTKEY']
        self.RegisterHotKey(HOTKEY_ID, hotkey[0], hotkey[1])
    
    def findWord(self, event):
        global _WORD 
        for i in range(10):
            subprocess.call(['python', 'MyDicGetText.py']) 
            #subprocess.call(['MyDicGetText.exe'])
            time.sleep(1)
            if wx.TheClipboard.Open():
                do = wx.TextDataObject()
                if wx.TheClipboard.GetData(do):
                    word = do.GetText() 
                    if word != _WORD:
                        webbrowser.open(CONFIG['URI_TEMPLATE']%(word.strip()))
                        _WORD = word
                        print 'WORD:', word
                        break
                    else:
                        print 'EXCEPTION count:', i
            
                wx.TheClipboard.Close()
        
def main(argv=None):
    global CONFIG
    with open('MyDic.ini', 'rt') as f:
        cs = f.readlines()
        for c in cs:
            key = c.split('=', 1)[0].strip()
            value = eval(c.split('=', 1)[1].strip())
            CONFIG[key] = value
            
    app = wx.App(False)  
    frame = MyDicFrame(None, -1, ' ')  
    frame.Center(wx.BOTH)  
    frame.Show(False) 
    app.MainLoop()  

if __name__ == '__main__':  
    main()
