/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;

public class SocketChannelIOHelper {
    public static boolean read(ByteBuffer buf, WebSocketImpl ws, ByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.read(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return read != 0;
    }

    public static boolean readMore(ByteBuffer buf, WebSocketImpl ws, WrappedByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.readMore(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return channel.isNeedRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean batch(WebSocketImpl ws, ByteChannel sockchannel) throws IOException {
        ByteBuffer buffer = (ByteBuffer)ws.outQueue.peek();
        if (buffer == null) {
            WrappedByteChannel c;
            if (sockchannel instanceof WrappedByteChannel && (c = (WrappedByteChannel)sockchannel).isNeedWrite()) {
                c.writeMore();
            }
        } else {
            do {
                sockchannel.write(buffer);
                if (buffer.remaining() > 0) {
                    return false;
                }
                ws.outQueue.poll();
            } while ((buffer = (ByteBuffer)ws.outQueue.peek()) != null);
        }
        if (ws.isClosed()) {
            WebSocketImpl webSocketImpl = ws;
            synchronized (webSocketImpl) {
                sockchannel.close();
            }
        }
        return sockchannel instanceof WrappedByteChannel ? !((WrappedByteChannel)sockchannel).isNeedWrite() : true;
    }
}

