/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.NotYetConnectedException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.java_websocket.client.WebSocketClient;

public class ServerStressTest
extends JFrame {
    private JSlider clients;
    private JSlider interval;
    private JSlider joinrate;
    private JButton start;
    private JButton stop;
    private JButton reset;
    private JLabel joinratelabel = new JLabel();
    private JLabel clientslabel = new JLabel();
    private JLabel intervallabel = new JLabel();
    private JTextField uriinput = new JTextField("ws://localhost:8887");
    private JTextArea text = new JTextArea("payload");
    private Timer timer = new Timer(true);
    private Thread adjustthread;
    private int notyetconnected = 0;
    List<WebSocketClient> websockets = Collections.synchronizedList(new LinkedList());
    URI uri;

    public ServerStressTest() {
        this.setTitle("ServerStressTest");
        this.setDefaultCloseOperation(3);
        this.start = new JButton("Start");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerStressTest.this.start.setEnabled(false);
                ServerStressTest.this.stop.setEnabled(true);
                ServerStressTest.this.reset.setEnabled(false);
                ServerStressTest.this.interval.setEnabled(false);
                ServerStressTest.this.clients.setEnabled(false);
                ServerStressTest.this.stopAdjust();
                ServerStressTest.this.adjustthread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServerStressTest.this.adjust();
                        }
                        catch (InterruptedException e) {
                            System.out.println("adjust chanced");
                        }
                    }
                });
                ServerStressTest.this.adjustthread.start();
            }
        });
        this.stop = new JButton("Stop");
        this.stop.setEnabled(false);
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerStressTest.this.timer.cancel();
                ServerStressTest.this.stopAdjust();
                ServerStressTest.this.start.setEnabled(true);
                ServerStressTest.this.stop.setEnabled(false);
                ServerStressTest.this.reset.setEnabled(true);
                ServerStressTest.this.joinrate.setEnabled(true);
                ServerStressTest.this.interval.setEnabled(true);
                ServerStressTest.this.clients.setEnabled(true);
            }
        });
        this.reset = new JButton("reset");
        this.reset.setEnabled(true);
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                while (!ServerStressTest.this.websockets.isEmpty()) {
                    ServerStressTest.this.websockets.remove(0).close();
                }
            }
        });
        this.joinrate = new JSlider(0, 5000);
        this.joinrate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServerStressTest.this.joinratelabel.setText("Joinrate: " + ServerStressTest.this.joinrate.getValue() + " ms ");
            }
        });
        this.clients = new JSlider(0, 10000);
        this.clients.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServerStressTest.this.clientslabel.setText("Clients: " + ServerStressTest.this.clients.getValue());
            }
        });
        this.interval = new JSlider(0, 5000);
        this.interval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServerStressTest.this.intervallabel.setText("Interval: " + ServerStressTest.this.interval.getValue() + " ms ");
            }
        });
        this.setSize(300, 400);
        this.setLayout(new GridLayout(10, 1, 10, 10));
        this.add(new JLabel("URI"));
        this.add(this.uriinput);
        this.add(this.joinratelabel);
        this.add(this.joinrate);
        this.add(this.clientslabel);
        this.add(this.clients);
        this.add(this.intervallabel);
        this.add(this.interval);
        JPanel south = new JPanel(new FlowLayout(1));
        this.add(this.text);
        this.add(south);
        south.add(this.start);
        south.add(this.stop);
        south.add(this.reset);
        this.joinrate.setValue(200);
        this.interval.setValue(1000);
        this.clients.setValue(1);
    }

    public void adjust() throws InterruptedException {
        System.out.println("Adjust");
        try {
            this.uri = new URI(this.uriinput.getText());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        int totalclients = this.clients.getValue();
        while (this.websockets.size() < totalclients) {
            ExampleClient cl = new ExampleClient(this.uri){

                @Override
                public void onClose(int code, String reason, boolean remote) {
                    System.out.println("Closed duo " + code + " " + reason);
                    ServerStressTest.this.clients.setValue(ServerStressTest.this.websockets.size());
                    ServerStressTest.this.websockets.remove(this);
                }
            };
            cl.connect();
            this.clients.setValue(this.websockets.size());
            this.websockets.add(cl);
            Thread.sleep(this.joinrate.getValue());
        }
        while (this.websockets.size() > this.clients.getValue()) {
            this.websockets.remove(0).close();
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ServerStressTest.this.send();
            }
        }, 0L, (long)this.interval.getValue());
    }

    public void stopAdjust() {
        if (this.adjustthread != null) {
            this.adjustthread.interrupt();
            try {
                this.adjustthread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        this.notyetconnected = 0;
        String payload = this.text.getText();
        long time1 = System.currentTimeMillis();
        List<WebSocketClient> list = this.websockets;
        synchronized (list) {
            for (WebSocketClient cl : this.websockets) {
                try {
                    cl.send(payload);
                }
                catch (NotYetConnectedException e) {
                    ++this.notyetconnected;
                }
            }
        }
        System.out.println(this.websockets.size() + "/" + this.notyetconnected + " clients sent \"" + payload + "\"" + (System.currentTimeMillis() - time1));
    }

    public static void main(String[] args) {
        new ServerStressTest().setVisible(true);
    }
}

