/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketListener;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.drafts.Draft_75;
import org.java_websocket.drafts.Draft_76;
import org.java_websocket.exceptions.IncompleteHandshakeException;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidFrameException;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.framing.CloseFrame;
import org.java_websocket.framing.CloseFrameBuilder;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.Charsetfunctions;

public class WebSocketImpl
extends WebSocket {
    public SelectionKey key;
    public final Socket socket;
    public ByteChannel channel;
    public final BlockingQueue<ByteBuffer> outQueue = new LinkedBlockingQueue<ByteBuffer>();
    public final BlockingQueue<ByteBuffer> inQueue = new LinkedBlockingQueue<ByteBuffer>();
    public volatile WebSocketServer.WebSocketWorker workerThread;
    private volatile boolean handshakeComplete = false;
    private volatile boolean closeHandshakeSent = false;
    private volatile boolean connectionClosed = false;
    private final WebSocketListener wsl;
    private List<Draft> knownDrafts;
    private Draft draft = null;
    private WebSocket.Role role;
    private Framedata tempContiniousFrame;
    private ByteBuffer tmpHandshakeBytes;
    private ClientHandshake handshakerequest = null;

    public WebSocketImpl(WebSocketListener listener, List<Draft> drafts, Socket sock) {
        this(listener, (Draft)null, sock);
        this.role = WebSocket.Role.SERVER;
        if (this.knownDrafts == null || drafts.isEmpty()) {
            this.knownDrafts = new ArrayList<Draft>(1);
            this.knownDrafts.add(new Draft_17());
            this.knownDrafts.add(new Draft_10());
            this.knownDrafts.add(new Draft_76());
            this.knownDrafts.add(new Draft_75());
        } else {
            this.knownDrafts = drafts;
        }
    }

    public WebSocketImpl(WebSocketListener listener, Draft draft, Socket sock) {
        this.wsl = listener;
        this.role = WebSocket.Role.CLIENT;
        this.draft = draft;
        this.socket = sock;
    }

    public void decode(ByteBuffer socketBuffer) throws IOException {
        if (!socketBuffer.hasRemaining() || this.connectionClosed) {
            return;
        }
        if (DEBUG) {
            System.out.println("process(" + socketBuffer.remaining() + "): {" + (socketBuffer.remaining() > 1000 ? "too big to display" : new String(socketBuffer.array(), socketBuffer.position(), socketBuffer.remaining())) + "}");
        }
        if (this.handshakeComplete) {
            this.decodeFrames(socketBuffer);
        } else if (this.decodeHandshake(socketBuffer)) {
            this.decodeFrames(socketBuffer);
        }
        assert (this.isClosing() || this.isClosed() || !socketBuffer.hasRemaining());
    }

    private boolean decodeHandshake(ByteBuffer socketBufferNew) throws IOException {
        block27: {
            ByteBuffer socketBuffer;
            if (this.tmpHandshakeBytes == null) {
                socketBuffer = socketBufferNew;
            } else {
                if (this.tmpHandshakeBytes.remaining() < socketBufferNew.remaining()) {
                    ByteBuffer buf = ByteBuffer.allocate(this.tmpHandshakeBytes.capacity() + socketBufferNew.remaining());
                    this.tmpHandshakeBytes.flip();
                    buf.put(this.tmpHandshakeBytes);
                    this.tmpHandshakeBytes = buf;
                }
                this.tmpHandshakeBytes.put(socketBufferNew);
                this.tmpHandshakeBytes.flip();
                socketBuffer = this.tmpHandshakeBytes;
            }
            socketBuffer.mark();
            try {
                Draft.HandshakeState isflashedgecase;
                if (this.draft == null && (isflashedgecase = this.isFlashEdgeCase(socketBuffer)) == Draft.HandshakeState.MATCHED) {
                    this.write(ByteBuffer.wrap(Charsetfunctions.utf8Bytes(this.wsl.getFlashPolicy(this))));
                    this.close(-3, "");
                    return false;
                }
                Draft.HandshakeState handshakestate = null;
                try {
                    if (this.role == WebSocket.Role.SERVER) {
                        if (this.draft == null) {
                            for (Draft d : this.knownDrafts) {
                                try {
                                    ServerHandshakeBuilder response;
                                    d.setParseMode(this.role);
                                    socketBuffer.reset();
                                    Handshakedata tmphandshake = d.translateHandshake(socketBuffer);
                                    if (!(tmphandshake instanceof ClientHandshake)) {
                                        this.closeConnection(1002, "wrong http function", false);
                                        return false;
                                    }
                                    ClientHandshake handshake = (ClientHandshake)tmphandshake;
                                    handshakestate = d.acceptHandshakeAsServer(handshake);
                                    if (handshakestate != Draft.HandshakeState.MATCHED) continue;
                                    try {
                                        response = this.wsl.onWebsocketHandshakeReceivedAsServer(this, d, handshake);
                                    }
                                    catch (InvalidDataException e) {
                                        this.closeConnection(e.getCloseCode(), e.getMessage(), false);
                                        return false;
                                    }
                                    this.write(d.createHandshake(d.postProcessHandshakeResponseAsServer(handshake, response), this.role));
                                    this.draft = d;
                                    this.open(handshake);
                                    return true;
                                }
                                catch (InvalidHandshakeException e) {
                                }
                            }
                            if (this.draft == null) {
                                this.close(1002, "no draft matches");
                            }
                            return false;
                        }
                        Handshakedata tmphandshake = this.draft.translateHandshake(socketBuffer);
                        if (!(tmphandshake instanceof ClientHandshake)) {
                            this.closeConnection(1002, "wrong http function", false);
                            return false;
                        }
                        ClientHandshake handshake = (ClientHandshake)tmphandshake;
                        handshakestate = this.draft.acceptHandshakeAsServer(handshake);
                        if (handshakestate == Draft.HandshakeState.MATCHED) {
                            this.open(handshake);
                            return true;
                        }
                        this.close(1002, "the handshake did finaly not match");
                        return false;
                    }
                    if (this.role != WebSocket.Role.CLIENT) break block27;
                    this.draft.setParseMode(this.role);
                    Handshakedata tmphandshake = this.draft.translateHandshake(socketBuffer);
                    if (!(tmphandshake instanceof ServerHandshake)) {
                        this.closeConnection(1002, "Wwrong http function", false);
                        return false;
                    }
                    ServerHandshake handshake = (ServerHandshake)tmphandshake;
                    handshakestate = this.draft.acceptHandshakeAsClient(this.handshakerequest, handshake);
                    if (handshakestate == Draft.HandshakeState.MATCHED) {
                        try {
                            this.wsl.onWebsocketHandshakeReceivedAsClient(this, this.handshakerequest, handshake);
                        }
                        catch (InvalidDataException e) {
                            this.closeConnection(e.getCloseCode(), e.getMessage(), false);
                            return false;
                        }
                        this.open(handshake);
                        return true;
                    }
                    this.close(1002, "draft " + this.draft + " refuses handshake");
                }
                catch (InvalidHandshakeException e) {
                    this.close(e);
                }
            }
            catch (IncompleteHandshakeException e) {
                if (this.tmpHandshakeBytes == null) {
                    socketBuffer.reset();
                    int newsize = e.getPreferedSize();
                    if (newsize == 0) {
                        newsize = socketBuffer.capacity() + 16;
                    } else assert (e.getPreferedSize() >= socketBuffer.remaining());
                    this.tmpHandshakeBytes = ByteBuffer.allocate(newsize);
                    this.tmpHandshakeBytes.put(socketBufferNew);
                }
                this.tmpHandshakeBytes.position(this.tmpHandshakeBytes.limit());
                this.tmpHandshakeBytes.limit(this.tmpHandshakeBytes.capacity());
            }
        }
        return false;
    }

    private void decodeFrames(ByteBuffer socketBuffer) {
        try {
            List<Framedata> frames = this.draft.translateFrame(socketBuffer);
            for (Framedata f : frames) {
                Framedata.Opcode curop;
                if (DEBUG) {
                    System.out.println("matched frame: " + f);
                }
                if ((curop = f.getOpcode()) == Framedata.Opcode.CLOSING) {
                    int code = 1005;
                    String reason = "";
                    if (f instanceof CloseFrame) {
                        CloseFrame cf = (CloseFrame)f;
                        code = cf.getCloseCode();
                        reason = cf.getMessage();
                    }
                    if (this.closeHandshakeSent) {
                        this.closeConnection(code, reason, true);
                        continue;
                    }
                    if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.TWOWAY) {
                        this.close(code, reason);
                    }
                    this.closeConnection(code, reason, false);
                    continue;
                }
                if (curop == Framedata.Opcode.PING) {
                    this.wsl.onWebsocketPing(this, f);
                    continue;
                }
                if (curop == Framedata.Opcode.PONG) {
                    this.wsl.onWebsocketPong(this, f);
                    continue;
                }
                if (this.tempContiniousFrame == null) {
                    if (f.getOpcode() == Framedata.Opcode.CONTINUOUS) {
                        throw new InvalidFrameException("unexpected continious frame");
                    }
                    if (f.isFin()) {
                        this.deliverMessage(f);
                        continue;
                    }
                    this.tempContiniousFrame = f;
                    continue;
                }
                if (f.getOpcode() == Framedata.Opcode.CONTINUOUS) {
                    this.tempContiniousFrame.append(f);
                    if (!f.isFin()) continue;
                    this.deliverMessage(this.tempContiniousFrame);
                    this.tempContiniousFrame = null;
                    continue;
                }
                throw new InvalidDataException(1002, "non control or continious frame expected");
            }
        }
        catch (InvalidDataException e1) {
            this.wsl.onWebsocketError(this, e1);
            this.close(e1);
            return;
        }
    }

    @Override
    public void close(int code, String message) {
        if (!this.closeHandshakeSent) {
            if (this.handshakeComplete) {
                if (code == 1006) {
                    this.closeConnection(code, true);
                    this.closeHandshakeSent = true;
                    return;
                }
                if (this.draft.getCloseHandshakeType() != Draft.CloseHandshakeType.NONE) {
                    try {
                        this.sendFrame(new CloseFrameBuilder(code, message));
                    }
                    catch (InvalidDataException e) {
                        this.wsl.onWebsocketError(this, e);
                        this.closeConnection(1006, "generated frame is invalid", false);
                    }
                } else {
                    this.closeConnection(code, false);
                }
            } else if (code == -3) {
                this.closeConnection(-3, true);
            } else {
                this.closeConnection(-1, false);
            }
            if (code == 1002) {
                this.closeConnection(code, false);
            }
            this.closeHandshakeSent = true;
            this.tmpHandshakeBytes = null;
            return;
        }
    }

    protected synchronized void closeConnection(int code, String message, boolean remote) {
        if (this.connectionClosed) {
            return;
        }
        this.connectionClosed = true;
        this.wsl.onWriteDemand(this);
        this.wsl.onWebsocketClose(this, code, message, remote);
        if (this.draft != null) {
            this.draft.reset();
        }
        this.tempContiniousFrame = null;
        this.handshakerequest = null;
    }

    protected void closeConnection(int code, boolean remote) {
        this.closeConnection(code, "", remote);
    }

    public void eot() {
        if (this.draft == null) {
            this.closeConnection(1006, true);
        } else if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.NONE) {
            this.closeConnection(1000, true);
        } else if (this.draft.getCloseHandshakeType() == Draft.CloseHandshakeType.ONEWAY) {
            if (this.role == WebSocket.Role.SERVER) {
                this.closeConnection(1006, true);
            } else {
                this.closeConnection(1000, true);
            }
        } else {
            this.closeConnection(1006, true);
        }
    }

    @Override
    public void close(int code) {
        this.close(code, "");
    }

    @Override
    public void close(InvalidDataException e) {
        this.close(e.getCloseCode(), e.getMessage());
    }

    @Override
    public void send(String text) throws NotYetConnectedException {
        if (text == null) {
            throw new IllegalArgumentException("Cannot send 'null' data to a WebSocketImpl.");
        }
        this.send(this.draft.createFrames(text, this.role == WebSocket.Role.CLIENT));
    }

    @Override
    public void send(ByteBuffer bytes) throws IllegalArgumentException, NotYetConnectedException {
        if (bytes == null) {
            throw new IllegalArgumentException("Cannot send 'null' data to a WebSocketImpl.");
        }
        this.send(this.draft.createFrames(bytes, this.role == WebSocket.Role.CLIENT));
    }

    @Override
    public void send(byte[] bytes) throws IllegalArgumentException, NotYetConnectedException {
        this.send(ByteBuffer.wrap(bytes));
    }

    private void send(Collection<Framedata> frames) {
        if (!this.handshakeComplete) {
            throw new NotYetConnectedException();
        }
        for (Framedata f : frames) {
            this.sendFrame(f);
        }
    }

    @Override
    public void sendFrame(Framedata framedata) {
        if (DEBUG) {
            System.out.println("send frame: " + framedata);
        }
        this.write(this.draft.createBinaryFrame(framedata));
    }

    @Override
    public boolean hasBufferedData() {
        return !this.outQueue.isEmpty();
    }

    private Draft.HandshakeState isFlashEdgeCase(ByteBuffer request) throws IncompleteHandshakeException {
        request.mark();
        if (request.limit() > Draft.FLASH_POLICY_REQUEST.length) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        if (request.limit() < Draft.FLASH_POLICY_REQUEST.length) {
            throw new IncompleteHandshakeException(Draft.FLASH_POLICY_REQUEST.length);
        }
        int flash_policy_index = 0;
        while (request.hasRemaining()) {
            if (Draft.FLASH_POLICY_REQUEST[flash_policy_index] != request.get()) {
                request.reset();
                return Draft.HandshakeState.NOT_MATCHED;
            }
            ++flash_policy_index;
        }
        return Draft.HandshakeState.MATCHED;
    }

    @Override
    public void startHandshake(ClientHandshakeBuilder handshakedata) throws InvalidHandshakeException {
        if (this.handshakeComplete) {
            throw new IllegalStateException("Handshake has already been sent.");
        }
        this.handshakerequest = this.draft.postProcessHandshakeRequestAsClient(handshakedata);
        try {
            this.wsl.onWebsocketHandshakeSentAsClient(this, this.handshakerequest);
        }
        catch (InvalidDataException e) {
            throw new InvalidHandshakeException("Handshake data rejected by client.");
        }
        this.write(this.draft.createHandshake(this.handshakerequest, this.role));
    }

    private void write(ByteBuffer buf) {
        if (DEBUG) {
            System.out.println("write(" + buf.remaining() + "): {" + (buf.remaining() > 1000 ? "too big to display" : new String(buf.array())) + "}");
        }
        this.outQueue.add(buf);
        this.wsl.onWriteDemand(this);
    }

    private void write(List<ByteBuffer> bufs) {
        for (ByteBuffer b : bufs) {
            this.write(b);
        }
    }

    private void deliverMessage(Framedata d) throws InvalidDataException {
        try {
            if (d.getOpcode() == Framedata.Opcode.TEXT) {
                this.wsl.onWebsocketMessage((WebSocket)this, Charsetfunctions.stringUtf8(d.getPayloadData()));
            } else if (d.getOpcode() == Framedata.Opcode.BINARY) {
                this.wsl.onWebsocketMessage((WebSocket)this, d.getPayloadData());
            } else {
                if (DEBUG) {
                    System.out.println("Ignoring frame:" + d.toString());
                }
                assert (false);
            }
        }
        catch (RuntimeException e) {
            this.wsl.onWebsocketError(this, e);
        }
    }

    private void open(Handshakedata d) throws IOException {
        if (DEBUG) {
            System.out.println("open using draft: " + this.draft.getClass().getSimpleName());
        }
        this.handshakeComplete = true;
        this.wsl.onWebsocketOpen(this, d);
    }

    @Override
    public boolean isConnecting() {
        return !this.connectionClosed && !this.closeHandshakeSent && !this.handshakeComplete;
    }

    @Override
    public boolean isOpen() {
        return !this.connectionClosed && !this.closeHandshakeSent && this.handshakeComplete;
    }

    @Override
    public boolean isClosing() {
        return !this.connectionClosed && this.closeHandshakeSent;
    }

    @Override
    public boolean isClosed() {
        return this.connectionClosed;
    }

    @Override
    public int getReadyState() {
        if (this.isConnecting()) {
            return 0;
        }
        if (this.isOpen()) {
            return 1;
        }
        if (this.isClosing()) {
            return 2;
        }
        if (this.isClosed()) {
            return 3;
        }
        assert (false);
        return -1;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    public Draft getDraft() {
        return this.draft;
    }
}

