/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.drafts;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.java_websocket.drafts.Draft;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.exceptions.NotSendableException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.FramedataImpl1;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.HandshakeBuilder;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.util.Charsetfunctions;

public class Draft_75
extends Draft {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte START_OF_FRAME = 0;
    public static final byte END_OF_FRAME = -1;
    protected boolean readingState = false;
    private boolean inframe = false;
    protected List<Framedata> readyframes = new LinkedList<Framedata>();
    protected ByteBuffer currentFrame;
    private final Random reuseableRandom = new Random();

    @Override
    public Draft.HandshakeState acceptHandshakeAsClient(ClientHandshake request, ServerHandshake response) {
        return request.getFieldValue("WebSocket-Origin").equals(response.getFieldValue("Origin")) && this.basicAccept(response) ? Draft.HandshakeState.MATCHED : Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsServer(ClientHandshake handshakedata) {
        if (handshakedata.hasFieldValue("Origin") && this.basicAccept(handshakedata)) {
            return Draft.HandshakeState.MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public ByteBuffer createBinaryFrame(Framedata framedata) {
        if (framedata.getOpcode() != Framedata.Opcode.TEXT) {
            throw new RuntimeException("only text frames supported");
        }
        ByteBuffer pay = framedata.getPayloadData();
        ByteBuffer b = ByteBuffer.allocate(pay.remaining() + 2);
        b.put((byte)0);
        pay.mark();
        b.put(pay);
        pay.reset();
        b.put((byte)-1);
        b.flip();
        return b;
    }

    @Override
    public List<Framedata> createFrames(ByteBuffer binary, boolean mask) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public List<Framedata> createFrames(String text, boolean mask) {
        FramedataImpl1 frame = new FramedataImpl1();
        try {
            frame.setPayload(ByteBuffer.wrap(Charsetfunctions.utf8Bytes(text)));
        }
        catch (InvalidDataException e) {
            throw new NotSendableException(e);
        }
        frame.setFin(true);
        frame.setOptcode(Framedata.Opcode.TEXT);
        frame.setTransferemasked(mask);
        return Collections.singletonList(frame);
    }

    @Override
    public ClientHandshakeBuilder postProcessHandshakeRequestAsClient(ClientHandshakeBuilder request) throws InvalidHandshakeException {
        request.put("Upgrade", "WebSocket");
        request.put("Connection", "Upgrade");
        if (!request.hasFieldValue("Origin")) {
            request.put("Origin", "random" + this.reuseableRandom.nextInt());
        }
        return request;
    }

    @Override
    public HandshakeBuilder postProcessHandshakeResponseAsServer(ClientHandshake request, ServerHandshakeBuilder response) throws InvalidHandshakeException {
        response.setHttpStatusMessage("Web Socket Protocol Handshake");
        response.put("Upgrade", "WebSocket");
        response.put("Connection", request.getFieldValue("Connection"));
        response.put("WebSocket-Origin", request.getFieldValue("Origin"));
        String location = "ws://" + request.getFieldValue("Host") + request.getResourceDescriptor();
        response.put("WebSocket-Location", location);
        return response;
    }

    protected List<Framedata> translateRegularFrame(ByteBuffer buffer) throws InvalidDataException {
        while (buffer.hasRemaining()) {
            byte newestByte = buffer.get();
            if (newestByte == 0) {
                if (this.readingState) {
                    return null;
                }
                this.readingState = true;
                continue;
            }
            if (newestByte == -1) {
                if (!this.readingState) {
                    return null;
                }
                if (this.currentFrame != null) {
                    this.currentFrame.flip();
                    FramedataImpl1 curframe = new FramedataImpl1();
                    curframe.setPayload(this.currentFrame);
                    curframe.setFin(true);
                    curframe.setOptcode(this.inframe ? Framedata.Opcode.CONTINUOUS : Framedata.Opcode.TEXT);
                    this.readyframes.add(curframe);
                    this.currentFrame = null;
                    buffer.mark();
                }
                this.readingState = false;
                this.inframe = false;
                continue;
            }
            if (this.readingState) {
                if (this.currentFrame == null) {
                    this.currentFrame = this.createBuffer();
                } else if (!this.currentFrame.hasRemaining()) {
                    this.currentFrame = this.increaseBuffer(this.currentFrame);
                }
                this.currentFrame.put(newestByte);
                continue;
            }
            return null;
        }
        if (this.readingState) {
            FramedataImpl1 curframe = new FramedataImpl1();
            this.currentFrame.flip();
            curframe.setPayload(this.currentFrame);
            curframe.setFin(false);
            curframe.setOptcode(this.inframe ? Framedata.Opcode.CONTINUOUS : Framedata.Opcode.TEXT);
            this.inframe = true;
            this.readyframes.add(curframe);
        }
        List<Framedata> frames = this.readyframes;
        this.readyframes = new LinkedList<Framedata>();
        this.currentFrame = null;
        return frames;
    }

    @Override
    public List<Framedata> translateFrame(ByteBuffer buffer) throws InvalidDataException {
        List<Framedata> frames = this.translateRegularFrame(buffer);
        if (frames == null) {
            throw new InvalidDataException(1002);
        }
        return frames;
    }

    @Override
    public void reset() {
        this.readingState = false;
        this.currentFrame = null;
    }

    @Override
    public Draft.CloseHandshakeType getCloseHandshakeType() {
        return Draft.CloseHandshakeType.NONE;
    }

    public ByteBuffer createBuffer() {
        return ByteBuffer.allocate(INITIAL_FAMESIZE);
    }

    public ByteBuffer increaseBuffer(ByteBuffer full) {
        full.flip();
        ByteBuffer newbuffer = ByteBuffer.allocate(full.capacity() * 2);
        newbuffer.put(full);
        return newbuffer;
    }
}

