/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_10;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.drafts.Draft_75;
import org.java_websocket.drafts.Draft_76;
import org.java_websocket.handshake.ServerHandshake;

public class ChatClient
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -6056260699202978657L;
    private final JTextField uriField;
    private final JButton connect;
    private final JButton close;
    private final JTextArea ta;
    private final JTextField chatField;
    private final JComboBox draft;
    private WebSocketClient cc;

    public ChatClient(String defaultlocation) {
        super("WebSocket Chat Client");
        Container c = this.getContentPane();
        GridLayout layout = new GridLayout();
        layout.setColumns(1);
        layout.setRows(6);
        c.setLayout(layout);
        Draft[] drafts = new Draft[]{new Draft_17(), new Draft_10(), new Draft_76(), new Draft_75()};
        this.draft = new JComboBox<Draft>(drafts);
        c.add(this.draft);
        this.uriField = new JTextField();
        this.uriField.setText(defaultlocation);
        c.add(this.uriField);
        this.connect = new JButton("Connect");
        this.connect.addActionListener(this);
        c.add(this.connect);
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        this.close.setEnabled(false);
        c.add(this.close);
        JScrollPane scroll = new JScrollPane();
        this.ta = new JTextArea();
        scroll.setViewportView(this.ta);
        c.add(scroll);
        this.chatField = new JTextField();
        this.chatField.setText("");
        this.chatField.addActionListener(this);
        c.add(this.chatField);
        Dimension d = new Dimension(300, 400);
        this.setPreferredSize(d);
        this.setSize(d);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ChatClient.this.cc != null) {
                    ChatClient.this.cc.close();
                }
                ChatClient.this.dispose();
            }
        });
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.chatField) {
            if (this.cc != null) {
                this.cc.send(this.chatField.getText());
                this.chatField.setText("");
                this.chatField.requestFocus();
            }
        } else if (e.getSource() == this.connect) {
            try {
                this.cc = new WebSocketClient(new URI(this.uriField.getText()), (Draft)this.draft.getSelectedItem()){

                    @Override
                    public void onMessage(String message) {
                        ChatClient.this.ta.append("got: " + message + "\n");
                        ChatClient.this.ta.setCaretPosition(ChatClient.this.ta.getDocument().getLength());
                    }

                    @Override
                    public void onOpen(ServerHandshake handshake) {
                        ChatClient.this.ta.append("You are connected to ChatServer: " + this.getURI() + "\n");
                        ChatClient.this.ta.setCaretPosition(ChatClient.this.ta.getDocument().getLength());
                    }

                    @Override
                    public void onClose(int code, String reason, boolean remote) {
                        ChatClient.this.ta.append("You have been disconnected from: " + this.getURI() + "; Code: " + code + " " + reason + "\n");
                        ChatClient.this.ta.setCaretPosition(ChatClient.this.ta.getDocument().getLength());
                        ChatClient.this.connect.setEnabled(true);
                        ChatClient.this.uriField.setEditable(true);
                        ChatClient.this.draft.setEditable(true);
                        ChatClient.this.close.setEnabled(false);
                    }

                    @Override
                    public void onError(Exception ex) {
                        ChatClient.this.ta.append("Exception occured ...\n" + ex + "\n");
                        ChatClient.this.ta.setCaretPosition(ChatClient.this.ta.getDocument().getLength());
                        ex.printStackTrace();
                        ChatClient.this.connect.setEnabled(true);
                        ChatClient.this.uriField.setEditable(true);
                        ChatClient.this.draft.setEditable(true);
                        ChatClient.this.close.setEnabled(false);
                    }
                };
                this.close.setEnabled(true);
                this.connect.setEnabled(false);
                this.uriField.setEditable(false);
                this.draft.setEditable(false);
                this.cc.connect();
            }
            catch (URISyntaxException ex) {
                this.ta.append(this.uriField.getText() + " is not a valid WebSocket URI\n");
            }
        } else if (e.getSource() == this.close) {
            this.cc.close();
        }
    }

    public static void main(String[] args) {
        String location;
        WebSocket.DEBUG = true;
        if (args.length != 0) {
            location = args[0];
            System.out.println("Default server url specified: '" + location + "'");
        } else {
            location = "ws://localhost:8887";
            System.out.println("Default server url not specified: defaulting to '" + location + "'");
        }
        new ChatClient(location);
    }
}

