/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.java_websocket.WrappedByteChannel;

public class SSLSocketChannel2
implements ByteChannel,
WrappedByteChannel {
    protected static ByteBuffer emptybuffer = ByteBuffer.allocate(0);
    protected ExecutorService exec;
    protected List<Future<?>> tasks;
    protected ByteBuffer inData;
    protected ByteBuffer outCrypt;
    protected ByteBuffer inCrypt;
    protected SocketChannel sc;
    protected SelectionKey key;
    protected SSLEngineResult res;
    protected SSLEngine sslEngine;

    public SSLSocketChannel2(SelectionKey key, SSLEngine sslEngine, ExecutorService exec) throws IOException {
        this.sc = (SocketChannel)key.channel();
        this.key = key;
        this.sslEngine = sslEngine;
        this.exec = exec;
        this.tasks = new ArrayList(3);
        this.key.interestOps(key.interestOps() | 4);
        sslEngine.setEnableSessionCreation(true);
        SSLSession session = sslEngine.getSession();
        this.createBuffers(session);
        this.sc.write(this.wrap(emptybuffer));
        this.processHandshake();
    }

    private void processHandshake() throws IOException {
        if (!this.tasks.isEmpty()) {
            Iterator<Future<?>> it = this.tasks.iterator();
            while (it.hasNext()) {
                Future<?> f = it.next();
                if (f.isDone()) {
                    it.remove();
                    continue;
                }
                return;
            }
        }
        if (this.res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.inCrypt.compact();
            int read = this.sc.read(this.inCrypt);
            if (read == -1) {
                throw new IOException("connection closed unexpectedly by peer");
            }
            this.inCrypt.flip();
            this.inData.compact();
            this.unwrap();
        }
        this.consumeDelegatedTasks();
        if (this.tasks.isEmpty() || this.res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.sc.write(this.wrap(emptybuffer));
        }
    }

    private synchronized ByteBuffer wrap(ByteBuffer b) throws SSLException {
        this.outCrypt.compact();
        this.res = this.sslEngine.wrap(b, this.outCrypt);
        this.outCrypt.flip();
        return this.outCrypt;
    }

    private synchronized ByteBuffer unwrap() throws SSLException {
        int rem;
        do {
            rem = this.inData.remaining();
            this.res = this.sslEngine.unwrap(this.inCrypt, this.inData);
        } while (rem != this.inData.remaining());
        this.inData.flip();
        return this.inData;
    }

    protected void consumeDelegatedTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            this.tasks.add(this.exec.submit(task));
        }
    }

    protected void createBuffers(SSLSession session) {
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        this.inData = ByteBuffer.allocate(appBufferMax);
        this.outCrypt = ByteBuffer.allocate(netBufferMax);
        this.inCrypt = ByteBuffer.allocate(netBufferMax);
        this.inData.flip();
        this.inCrypt.flip();
        this.outCrypt.flip();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.isHandShakeComplete()) {
            this.processHandshake();
            return 0;
        }
        int num = this.sc.write(this.wrap(src));
        return num;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.isHandShakeComplete()) {
            this.processHandshake();
            return 0;
        }
        int purged = this.readRemaining(dst);
        if (purged != 0) {
            return purged;
        }
        assert (this.inData.position() == 0);
        this.inData.clear();
        if (!this.inCrypt.hasRemaining()) {
            this.inCrypt.clear();
        } else {
            this.inCrypt.compact();
        }
        if (this.sc.read(this.inCrypt) == -1) {
            return -1;
        }
        this.inCrypt.flip();
        this.unwrap();
        return this.transfereTo(this.inData, dst);
    }

    private int readRemaining(ByteBuffer dst) throws SSLException {
        assert (dst.hasRemaining());
        if (this.inData.hasRemaining()) {
            return this.transfereTo(this.inData, dst);
        }
        assert (!this.inData.hasRemaining());
        this.inData.clear();
        if (this.inCrypt.hasRemaining()) {
            this.unwrap();
            int amount = this.transfereTo(this.inData, dst);
            if (amount > 0) {
                return amount;
            }
        }
        return 0;
    }

    public boolean isConnected() {
        return this.sc.isConnected();
    }

    @Override
    public void close() throws IOException {
        this.sslEngine.closeOutbound();
        this.sslEngine.getSession().invalidate();
        if (this.sc.isOpen()) {
            this.sc.write(this.wrap(emptybuffer));
        }
        this.sc.close();
    }

    private boolean isHandShakeComplete() {
        SSLEngineResult.HandshakeStatus status = this.res.getHandshakeStatus();
        return status == SSLEngineResult.HandshakeStatus.FINISHED || status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public SelectableChannel configureBlocking(boolean b) throws IOException {
        return this.sc.configureBlocking(b);
    }

    public boolean connect(SocketAddress remote) throws IOException {
        return this.sc.connect(remote);
    }

    public boolean finishConnect() throws IOException {
        return this.sc.finishConnect();
    }

    public Socket socket() {
        return this.sc.socket();
    }

    public boolean isInboundDone() {
        return this.sslEngine.isInboundDone();
    }

    @Override
    public boolean isOpen() {
        return this.sc.isOpen();
    }

    @Override
    public boolean isNeedWrite() {
        return this.outCrypt.hasRemaining() || !this.isHandShakeComplete();
    }

    @Override
    public void writeMore() throws IOException {
        this.write(this.outCrypt);
    }

    @Override
    public boolean isNeedRead() {
        return this.inData.hasRemaining() || this.inCrypt.hasRemaining() && this.res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW;
    }

    @Override
    public int readMore(ByteBuffer dst) throws SSLException {
        return this.readRemaining(dst);
    }

    private int transfereTo(ByteBuffer from, ByteBuffer to) {
        int toremain;
        int fremain = from.remaining();
        if (fremain > (toremain = to.remaining())) {
            int limit = Math.min(fremain, toremain);
            for (int i = 0; i < limit; ++i) {
                to.put(from.get());
            }
            return limit;
        }
        to.put(from);
        return fremain;
    }
}

