#-*-coding: utf-8-*-

from email.mime.base import MIMEBase
from email.mime.text import MIMEText
from email.mime.image import MIMEImage

import smtplib
import mimetypes

import time
from datetime import timedelta

class Gmail(object):
    def __init__(self, subject, host, sender, password, recipient, s_time = 0):
        """
        host: 구글의 smtp 서버 사용
        sender: 전송자의 메일 주소
        recipient: 받는 사람의 메일 주소 
        """
        try:
            self.subject = subject
            self.host = host
            self.sender = sender
            self.recipient = recipient
            self.smtp = smtplib.SMTP(host, 587)
            self.smtp.starttls()
            self.smtp.login(sender, password)
            self.time = time.time()
            self.s_time = s_time
        except:
            pass

    def __del__(self):
        try:
            self.smtp.close()
        except:
            pass
        
    def push(self, string, files=None):
        """
        subject: 제목 입력
        string: 본문 내용 입력
        image: 첨부하고자 하는 그림이 하나일 경우 문자열로 ('image.jpg') 입력
            여러개일 경우 리스트로 입력, 첨부하고자 하는 그림이 없을 경우 생략가능 
        """
        if self.s_time != 0:
            p_time = 'Present time : %s\n'%time.ctime()
            e_time = 'Elapsed time : %s\n\n'%timedelta(seconds=time.time()-self.s_time)
                #d_time = 'Delta time   : %s\n\n'%timedelta(seconds=time.time()-self.time)
                #self.time = time.time()
                #string = p_time + e_time + d_time + string
            string = p_time + e_time + string
        else:
            string = '\n' + string
            
        msg = MIMEBase("multipart", "mixed")
        msg['Subject'] = self.subject
        msg['From'] = self.sender
        msg['To'] = self.recipient

        TextPart = MIMEText(string, _charset='utf-8')
        msg.attach(TextPart)

        for f in files:
            if f[-3:] in ['jpg', 'png']:
                imageFD = open(f, 'rb')
                ImagePart = MIMEImage(imageFD.read())
                ImagePart.add_header('Content-Disposition', 'attachment', filename=f)
                msg.attach(ImagePart)
                msg.add_header('Content-Disposition', 'attachment', filename=f)
                imageFD.close()
                print 'FILE: %s'%f
            elif f[-3:] in ['txt', 'log', 'csv']:
                FD = open(f, 'rb')
                TextPart = MIMEText(FD.read())
                TextPart.add_header('Content-Disposition', 'attachment', filename=f)
                msg.attach(TextPart)
                msg.add_header('Content-Disposition', 'attachment', filename=f)
                FD.close()
                print 'FILE: %s'%f
            else:
                #print f[-3:]
                TextPart = MIMEText('\n!!경고!! %s 파일을 찾을 수 없습니다.'%f, _charset='utf-8')
                msg.attach(TextPart)
            
        self.smtp.sendmail(self.sender, [self.recipient], msg.as_string())
        print string
        
        
#def push(subject, string, image=None):
#    mp.MailSender()
#    mp.push(subject, string, image)
        
if __name__ == '__main__':
    mp = Gmail()
    #s_time = time.time()
    mp.push("테스팅 파이썬 이메일 보내기, 왜 두개씩??")
    #print timedelta(seconds= time.time() - s_time)
    s_time = time.time()
    mp.push("테스팅 파이썬 이메일 보내기", 'HPF0fitness.png')
    #print timedelta(seconds= time.time() - s_time)
    #s_time = time.time()
    mp.push("테스팅 파이썬 이메일 보내기", ['HPF0fitness.png', 'HPF0fitness.png'])
    #print timedelta(seconds= time.time() - s_time)
    #s_time = time.time()
    mp.push("테스팅 파이썬 이메일 보내기", ['HPF0fitness.png', 'HPF0fitness.jpg'])
    #print timedelta(seconds= time.time() - s_time)
    
